/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.stats;

import com.google.common.collect.Maps;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StatsTracker {
    private Map<EntityType<?>, Integer> ENTITY_KILLS = Maps.newHashMap();
    private float damageDealt = 0.0f;
    private int distanceOnWater = 0;
    private int distanceInWater = 0;
    private int distanceSprinting = 0;
    private int distanceSneaking = 0;
    private int distanceWalking = 0;
    private int distanceRidden = 0;
    private final Cache<Integer> killCount = Cache.make(this::getTotalKillCountInternal);

    public void writeAdditional(CompoundNBT compound) {
        ListNBT killList = new ListNBT();
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            CompoundNBT stats = new CompoundNBT();
            NBTUtil.putRegistryValue(stats, "type", (IForgeRegistryEntry)entry.getKey());
            stats.func_74768_a("count", entry.getValue().intValue());
            killList.add((Object)stats);
        }
        compound.func_218657_a("entityKills", (INBT)killList);
        compound.func_74780_a("damageDealt", (double)this.damageDealt);
        compound.func_74768_a("distanceOnWater", this.distanceOnWater);
        compound.func_74768_a("distanceInWater", this.distanceInWater);
        compound.func_74768_a("distanceSprinting", this.distanceSprinting);
        compound.func_74768_a("distanceSneaking", this.distanceSneaking);
        compound.func_74768_a("distanceWalking", this.distanceWalking);
        compound.func_74768_a("distanceRidden", this.distanceRidden);
    }

    public void readAdditional(CompoundNBT compound) {
        ListNBT killList = compound.func_150295_c("entityKills", 10);
        for (int i = 0; i < killList.size(); ++i) {
            CompoundNBT stats = killList.func_150305_b(i);
            EntityType type = (EntityType)NBTUtil.getRegistryValue(stats, "type", ForgeRegistries.ENTITIES);
            this.ENTITY_KILLS.put(type, stats.func_74762_e("count"));
        }
        this.damageDealt = compound.func_74760_g("damageDealt");
        this.distanceOnWater = compound.func_74762_e("distanceOnWater");
        this.distanceInWater = compound.func_74762_e("distanceInWater");
        this.distanceSprinting = compound.func_74762_e("distanceSprinting");
        this.distanceSneaking = compound.func_74762_e("distanceSneaking");
        this.distanceWalking = compound.func_74762_e("distanceWalking");
        this.distanceRidden = compound.func_74762_e("distanceRidden");
    }

    public int getKillCountFor(EntityType<?> type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    public int getKillCountFor(Predicate<EntityClassification> classification) {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            if (!classification.test(entry.getKey().func_220339_d())) continue;
            total += entry.getValue().intValue();
        }
        return total;
    }

    private int getTotalKillCountInternal() {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public int getTotalKillCount() {
        return this.killCount.get();
    }

    public void incrementKillCount(Entity entity) {
        this.incrementKillCount(entity.func_200600_R());
    }

    private void incrementKillCount(EntityType<?> type) {
        this.ENTITY_KILLS.compute(type, (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void increaseDamageDealt(float damage) {
        this.damageDealt += damage;
    }

    public void increaseDistanceOnWater(int distance) {
        this.distanceOnWater += distance;
    }

    public void increaseDistanceInWater(int distance) {
        this.distanceInWater += distance;
    }

    public void increaseDistanceSprint(int distance) {
        this.distanceSprinting += distance;
    }

    public void increaseDistanceSneaking(int distance) {
        this.distanceSneaking += distance;
    }

    public void increaseDistanceWalk(int distance) {
        this.distanceWalking += distance;
    }

    public void increaseDistanceRidden(int distance) {
        this.distanceRidden += distance;
    }
}

